% forecasting_processes.m
% 
% forecasts of driving processes
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions/');
addpath('Utilities/')
addpath('Data/')

calvec = (1947:1:2018)';
SecName = {'Construction','Durable Goods','IPP Services','Nondurable Goods','Services'};


T_is = length(calvec);
q_is = 7;
h_os_save = 20;   % Number of out-of-sample forecasts to save
n_draws = 5000;
rng(7620085);   % For replication




%% -- PSI, ETA_X, ETA_M, TFP, LABOR SUPPLY   -- %
% Load Data
load([matdir 'psi_process'],'psi_nxg')
load([matdir 'driving_processes'],'eta_x','eta_m')
load([matdir 'tfp_process'],'tfp');
load([matdir 'model_output'],'varphi_model')

for ii = 1:5

    if ii == 1
        Y = log(varphi_model);
        varname = 'varphi';
    elseif ii == 2
        Y = psi_nxg;
        varname = 'psi';
    elseif ii == 3
        Y = log(eta_x./(1-eta_x));
        varname = 'eta_x';
    elseif ii == 4
        Y = log(eta_m./(1-eta_m));
        varname = 'eta_m';
    elseif ii == 5
        Y = log(tfp);
        varname = 'tfp';
    end


    T_is = size(Y,1);
    h_os = T_is;
    nS = size(Y,2);
    
    
    per_is = 2*T_is/q_is;
    fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
    fprintf('Number of Shortest Periods: %5.1f \n',per_is);
    
    % Get some results from I_1 model
    I_1 = 1;
    I_trend = 1;
    % [Yproj_is,Yproj_os_mean,Yproj_os_draws] = Y_oos_is_trend(Y,q_is,h_os,n_draws,I_1);
    [Yproj_is, Yproj_os_mean, trend_os_only, Yproj_os_draws] = fcst_y_trend(Y,q_is,h_os,n_draws,I_1,I_trend);
    T_os = size(Yproj_is,1);
    
    % Get percentiles across the draws
    pct = [0 0.17 0.5 0.83 1];
    Yproj_os_quantiles = NaN(T_os,nS,length(pct));
    for i = 1:nS
        Yproj_os_quantiles(:,i,:) = prctile(squeeze(Yproj_os_draws(:,i,:)),100*pct,2);
    end
    
    % Get 
    Y_is = [Y;NaN(T_os-T_is,size(Y,2))];
    
    % Get fs calendar vector for plotting
    calvec_os = calvec(1)+(0:1:T_os-1)';
    
    ax_fs = 15;
    % Augment the in-sample plot with os forecasts
    % fig2 = figure('Units', 'normalized', 'Position', [0 0 0.5 0.9]); % For Dell Wide Monitor
    for i = 1:5
        fig = figure('Units','Inches','Position',[1 1 2 2]);
        plot(calvec_os,Y_is(:,i),'- b','LineWidth',1);
        hold on;
            plot(calvec_os,Yproj_os_mean(:,i),'- b','LineWidth',2);
            % plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,1),': b','LineWidth',1);
            % plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,5),': b','LineWidth',1);
            plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,2),'-- b','LineWidth',1);
            plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,4),'-- b','LineWidth',1);
            % plot(calvec_os,Yproj_is(:,i),'- k','LineWidth',2);
        hold off;
        % title(SecName{i});
        xlim([calvec_os(1) 2040]);
        ax = gca;
        % ax.FontSize = ax_fs;
    
        % figure_to_png(figdir,['fcst_tfp_V1']);
        % close(gcf); 
        grid on
        box on
        % ax.FontSize = ax_fs;
        print(fig, [figdir, 'forecast_processes_' varname '_' strrep(SecName{i},' ','_')], '-depsc')
        close(fig)
    end

    eval([varname '_proj_os_draws = Yproj_os_draws(1:T_is+h_os_save,:,:);'])
end


%% -- Preferences  -- %
% Load Data
load('Output/driving_processes','Theta_t')
load('Output/model_output','rho_model')

for ii = 1:2

    if ii == 1
        Y = Theta_t;
        varname = 'Theta_t';
    elseif ii == 2
        Y = rho_model;
        varname = 'rho';
    end

    T_is = size(Y,1);
    h_os = T_is;
    nS = size(Y,2);

    per_is = 2*T_is/q_is;
    fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
    fprintf('Number of Shortest Periods: %5.1f \n',per_is);

    % Get some results from I_1 model
    I_1 = 1;
    I_trend = 1;
    % [Yproj_is,Yproj_os_mean,Yproj_os_draws] = Y_oos_is_trend(Y,q_is,h_os,n_draws,I_1);
    [Yproj_is, Yproj_os_mean, trend_os_only, Yproj_os_draws] = fcst_y_trend(Y,q_is,h_os,n_draws,I_1,I_trend);
    T_os = size(Yproj_is,1);

    % Get percentiles across the draws
    pct = [0 0.17 0.5 0.83 1];
    Yproj_os_quantiles = NaN(T_os,nS,length(pct));
    for i = 1:nS
        Yproj_os_quantiles(:,i,:) = prctile(squeeze(Yproj_os_draws(:,i,:)),100*pct,2);
    end

    % Get 
    Y_is = [Y;NaN(T_os-T_is,size(Y,2))];

    % Get fs calendar vector for plotting
    calvec_os = calvec(1)+(0:1:T_os-1)';

    ax_fs = 15;
    % Augment the in-sample plot with os forecasts
    % fig2 = figure('Units', 'normalized', 'Position', [0 0 0.5 0.9]); % For Dell Wide Monitor
    for i = 1
        fig = figure('Units','Inches','Position',[1 1 2 2]);
        plot(calvec_os,Y_is(:,i),'- b','LineWidth',1);
        hold on;
            plot(calvec_os,Yproj_os_mean(:,i),'- b','LineWidth',2);
            % plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,1),': b','LineWidth',1);
            % plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,5),': b','LineWidth',1);
            plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,2),'-- b','LineWidth',1);
            plot(calvec_os(T_is:T_os),Yproj_os_quantiles(T_is:T_os,i,4),'-- b','LineWidth',1);
            % plot(calvec_os,Yproj_is(:,i),'- k','LineWidth',2);
        hold off;
        % title(SecName{i});
        xlim([calvec_os(1) 2050]);
        ax = gca;
        % ax.FontSize = ax_fs;
    
        % figure_to_png(figdir,['fcst_tfp_V1']);
        % close(gcf); 
        grid on
        box on
        % ax.FontSize = ax_fs;
        print(fig, [figdir, 'forecast_processes_' varname], '-depsc')
        close(fig)
    end


    eval([varname '_proj_os_draws = Yproj_os_draws(1:T_is+h_os_save,:,:);'])
end











% % Save Key Results
save([matdir 'process_draws']);
% save_variables = {'Y_is','Yproj_is','Yproj_os_mean','Yproj_os_quantiles'};
% save([matdir 'fcst_tfp_V1.mat'],save_variables{:});
